/*
 * Decompiled with CFR 0.152.
 */
package com.malchrosoft.debug;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    private SimpleDateFormat df = new SimpleDateFormat("dd/MM/YYYY HH:mm:ss");
    private Level level = Level.INFO;
    private String modifierLocalization;
    private static Log instance;

    private Log() {
    }

    public final void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        }
    }

    public static Log get() {
        if (instance == null) {
            instance = new Log();
        }
        return instance;
    }

    public static String getModifierLocalization() {
        return Log.get().modifierLocalization;
    }

    public static synchronized void debug(String text) {
        if (Log.get().level.getValue() < Level.DEBUG.getValue()) {
            return;
        }
        Log.printWithTraceLine(Log.get().now() + "DEBUG : " + text, 1, System.out);
    }

    public static synchronized void info(String text) {
        if (Log.get().level.getValue() < Level.INFO.getValue()) {
            return;
        }
        Log.printWithTraceLine(ANSI_BLUE + Log.get().now() + "INFO : " + text + ANSI_RESET, 1, System.out);
    }

    public static synchronized void error(String text, Throwable ex) {
        Log.error(text);
        ex.printStackTrace();
    }

    public static synchronized void error(String text) {
        if (Log.get().level.getValue() < Level.ERROR.getValue()) {
            return;
        }
        Log.printWithTraceLine(ANSI_RED + Log.get().now() + "ERROR : " + text + ANSI_RESET, 1, System.out);
    }

    public static synchronized void warn(String text, Throwable ex) {
        Log.warn(text);
        ex.printStackTrace();
    }

    public static synchronized void warn(String text) {
        if (Log.get().level.getValue() < Level.ERROR.getValue()) {
            return;
        }
        Log.printWithTraceLine(ANSI_YELLOW + Log.get().now() + "WARN : " + text + ANSI_RESET, 1, System.out);
    }

    private static synchronized void printWithTraceLine(String text, int l, PrintStream s) {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        s.println(text);
        s.println("\tat " + trace[l + 1]);
    }

    private String now() {
        return this.df.format(new Date()) + "s ";
    }

    public static boolean isDebugMode() {
        return Log.get().level.value >= Level.DEBUG.value;
    }

    public static void main(String[] args) throws ClassNotFoundException, InterruptedException {
        Log.get().setLevel(Level.DEBUG);
        Thread.sleep(1000L);
        Log.debug("message");
        Thread.sleep(1000L);
        Log.error(Log.getModifierLocalization());
        Thread.sleep(1000L);
        Log.info(Log.getModifierLocalization());
        Thread.sleep(1000L);
        Log.warn("avertissement...");
        Thread.sleep(1000L);
        System.out.println("Test colors  \n\u001b[34mblue\n\u001b[36mcyan\n\u001b[32mgreen\n\u001b[35mpurple\n\u001b[31mred\n\u001b[37mwhite\n\u001b[33myellow\n\u001b[0mreset");
    }

    public static enum Level {
        DEBUG(3),
        INFO(2),
        WARN(1),
        ERROR(0),
        NO_LOG(-1);

        private int value;

        private Level(int value) {
            this.value = value;
        }

        protected int getValue() {
            return this.value;
        }
    }
}

