/*
 * Decompiled with CFR 0.152.
 */
package com.malchrosoft.filesorter;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.malchrosoft.debug.Log;
import com.malchrosoft.filesorter.AppInstance;
import com.malchrosoft.filesorter.FileAnalyzer;
import com.malchrosoft.filesorter.constant.HtmlColor;
import com.malchrosoft.filesorter.constant.TiffTag;
import com.malchrosoft.filesorter.graphic.ConsoleViewManager;
import com.malchrosoft.filesorter.graphic.MainFrameController;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JTextArea;

public class DirectoryAnalyzer {
    private File rootDirectory;
    private boolean resursiveTreatment;
    private boolean verbose;
    private long fileCount;
    private long totalSize;
    private long directoryCount;
    private long treatedCount;
    private long estimatedFileCount;
    private long estimatedTotalSize;
    private long estimatedDirectoryCount;
    private SortedMap<String, Integer> fileTypeCountMap;
    private SortedMap<String, Integer> fileMonthCountMap;
    private SortedMap<String, Integer> fileDestinationDirectoryCountMap;
    private boolean sort;
    private MainFrameController controller;
    private ConsoleViewManager c;
    private JTextArea console;
    private static SimpleDateFormat formatMonth = new SimpleDateFormat("YYYY-MM");
    private static SimpleDateFormat formatYear = new SimpleDateFormat("YYYY");

    private DirectoryAnalyzer() {
    }

    public DirectoryAnalyzer(File parentDirectory, boolean recursiveTreatment) {
        Log.debug(AppInstance.get().getController() + " ?");
        this.controller = AppInstance.get().getController();
        this.c = this.controller.getConsoleViewManager();
        this.console = this.controller.getConsole();
        this.c.appendLine("Analyser initialized with directory : <b><i>" + parentDirectory.getAbsolutePath() + "</i></b>");
        this.console.append("\n\n---------------------- NEW ANALYZE -------------------------\n");
        this.console.append("\tAnalyser initialized with directory : '" + parentDirectory.getAbsolutePath() + "'\n");
        this.console.append("------------------------------------------------------------\n");
        if (!parentDirectory.isDirectory() && parentDirectory.isFile() && parentDirectory.getParentFile().isDirectory()) {
            this.rootDirectory = parentDirectory.getParentFile();
        }
        this.rootDirectory = parentDirectory;
        this.resursiveTreatment = recursiveTreatment;
        this.console.append("\t***  READY ***\n");
        this.controller.setStatus("Ready to analyse directory");
    }

    public void setVerbose(boolean isVerbose) {
        this.verbose = isVerbose;
    }

    public final void analyse() {
        this.c.appendLine("Launches analyze...", HtmlColor.BLUE);
        this.console.append("\nLaunches analyze...");
        this.controller.setProgress(0);
        this.analyse(false);
    }

    public final void sort() {
        this.c.appendLine("Launches sort...", HtmlColor.ORANGE);
        this.console.append("\nLaunches sort...");
        this.analyse(true);
    }

    public final void clean() {
        this.c.appendLine("Launches cleaning...", HtmlColor.PINK);
        this.console.append("\nLaunches cleaning...");
        this.estimateFileCount();
        this.console.append("\n   - Variables initialization...");
        this.fileCount = 0L;
        this.treatedCount = 0L;
        this.totalSize = 0L;
        this.directoryCount = 0L;
        this.controller.setProgressIndeterminate(false);
        this.controller.setProgress(0);
        this.cleanEmptyDirectory(this.rootDirectory);
        this.console.append("\nClean empty directories :  " + this.treatedCount + " / " + this.directoryCount);
    }

    private void analyse(boolean sort) {
        this.estimateFileCount();
        this.console.append("\n   - Variables initialization...");
        this.sort = sort;
        this.fileCount = 0L;
        this.totalSize = 0L;
        this.directoryCount = 0L;
        this.controller.setProgressIndeterminate(false);
        this.controller.setProgress(0);
        this.fileTypeCountMap = new TreeMap<String, Integer>();
        this.fileMonthCountMap = new TreeMap<String, Integer>();
        this.fileDestinationDirectoryCountMap = new TreeMap<String, Integer>();
        this.console.append(" -> OK !\n\n-----------------------------------------------\n");
        long start = System.currentTimeMillis();
        this.analyse(this.rootDirectory);
        this.provideAnalyseResult(System.currentTimeMillis() - start);
    }

    private void cleanEmptyDirectory(File dir) {
        File[] subFiles;
        if (this.verbose) {
            this.console.append(dir.getName() + "\t[directory]\n");
        }
        for (File sf : subFiles = dir.listFiles()) {
            if (sf.isDirectory()) {
                ++this.directoryCount;
                if (this.resursiveTreatment) {
                    this.cleanEmptyDirectory(sf);
                }
                if (sf.listFiles().length == 0) {
                    if (this.verbose) {
                        this.console.append("      - Deletes empty directory : " + sf.getName() + '\n');
                    }
                    if (!sf.delete()) {
                        Log.error("Impossible to delete : " + sf.getAbsolutePath());
                        if (this.verbose) {
                            this.console.append("#E       ERROR : not deleted : " + sf.getAbsolutePath() + '\n');
                        }
                    } else {
                        ++this.treatedCount;
                    }
                    if (this.verbose) {
                        this.console.setCaretPosition(this.console.getText().length());
                    }
                }
            }
            this.controller.setStatus("Clean empty directories :  " + this.treatedCount + " / " + this.directoryCount);
            this.controller.setProgress(Math.round(this.directoryCount * 100L / this.estimatedDirectoryCount));
        }
    }

    public void estimateFileCount() {
        this.estimatedDirectoryCount = 0L;
        this.estimatedFileCount = 0L;
        this.estimatedTotalSize = 0L;
        this.c.appendLine("Estimates counters...", HtmlColor.BLUE);
        this.console.append("\nEstimates counters...");
        this.controller.setProgress(0);
        this.controller.setProgressIndeterminate(true);
        this.estimateFileCount(this.rootDirectory);
        this.controller.setProgressIndeterminate(false);
        this.controller.setProgress(100);
        this.controller.setStatus(this.estimatedFileCount + " files, " + this.estimatedDirectoryCount + " directories = " + (double)Math.round((double)this.estimatedTotalSize / 10000.0) / 100.0 + " Mb");
        this.console.append(" -> OK !");
    }

    private void estimateFileCount(File dir) {
        File[] subFiles;
        for (File sf : subFiles = dir.listFiles()) {
            if (sf.isFile()) {
                ++this.estimatedFileCount;
                this.estimatedTotalSize += sf.length();
            } else if (sf.isDirectory()) {
                ++this.estimatedDirectoryCount;
                if (this.resursiveTreatment) {
                    this.estimateFileCount(sf);
                }
            }
            this.controller.setStatus(this.estimatedFileCount + " files, " + this.estimatedDirectoryCount + " directories...");
        }
    }

    private void analyse(File dir) {
        File[] subFiles;
        if (this.verbose) {
            this.console.append(dir.getName() + "\t[directory]\n");
        }
        for (File sf : subFiles = dir.listFiles()) {
            if (sf.isFile()) {
                ++this.fileCount;
                this.totalSize += sf.length();
                if (this.verbose) {
                    this.console.append("      - " + sf.getName());
                }
                this.analyseMetadata(sf);
                if (this.verbose) {
                    this.console.append("\n");
                    this.console.setCaretPosition(this.console.getText().length());
                }
            } else if (sf.isDirectory()) {
                ++this.directoryCount;
                if (this.resursiveTreatment) {
                    this.analyse(sf);
                }
            }
            this.controller.setStatus(this.fileCount + " files, " + this.directoryCount + " directories...");
            this.controller.setProgress(Math.round(this.fileCount * 100L / this.estimatedFileCount));
        }
    }

    private void analyseMetadata(File file) {
        String newRelativeDir;
        String year = formatYear.format(new Date(file.lastModified()));
        String monthName = formatMonth.format(new Date(file.lastModified()));
        String ext = FileAnalyzer.getType(file);
        this.incrementMapValue(this.fileTypeCountMap, ext);
        Integer width = null;
        Integer height = null;
        try {
            Metadata imr = ImageMetadataReader.readMetadata(file);
            monthName = null;
            Date foundDate = null;
            for (Directory d : imr.getDirectories()) {
                if (d.containsTag(3)) {
                    width = d.getInteger(3);
                    height = d.getInteger(1);
                } else if (monthName == null && d.containsTag(306)) {
                    foundDate = d.getDate(306);
                } else if (monthName == null && d.containsTag(36868)) {
                    foundDate = d.getDate(36868);
                } else if (monthName == null && d.containsTag(36867)) {
                    foundDate = d.getDate(36867);
                } else if (width == null || height == null) {
                    if (d.containsTag(TiffTag.IMAGE_WIDTH.getId())) {
                        width = d.getInteger(TiffTag.IMAGE_WIDTH.getId());
                    }
                    if (d.containsTag(TiffTag.IMAGE_HEIGHT.getId())) {
                        height = d.getInteger(TiffTag.IMAGE_HEIGHT.getId());
                    }
                } else if (d.containsTag(40962)) {
                    width = d.getInteger(40962);
                    height = d.getInteger(40963);
                }
                if (foundDate == null) continue;
                monthName = formatMonth.format(foundDate);
                year = formatYear.format(foundDate);
            }
            if (monthName == null) {
                monthName = "_" + formatMonth.format(new Date(file.lastModified()));
            }
        }
        catch (ImageProcessingException ex) {
        }
        catch (IOException ex) {
            Log.error(ex.getLocalizedMessage());
            return;
        }
        this.incrementMapValue(this.fileMonthCountMap, monthName);
        String sizeReport = (double)Math.round((double)file.length() / 10000.0) / 100.0 + " Mb";
        switch (ext) {
            case "MPG": 
            case "MP4": 
            case "MOV": 
            case "AVI": {
                newRelativeDir = "VIDEOS" + File.separator + year + File.separator + monthName + File.separator;
                break;
            }
            default: {
                if (width != null && height != null) {
                    float mPixelSize = (float)(width * height) / 1000000.0f;
                    sizeReport = (float)Math.round(mPixelSize * 10.0f) / 10.0f + "MPix (w:" + width + "px * " + height + "px)";
                    if (mPixelSize < 0.3f) {
                        newRelativeDir = "IMAGES" + File.separator + "NO_PHOTO" + File.separator + year + File.separator + monthName + File.separator;
                        break;
                    }
                    if (mPixelSize < 1.0f) {
                        newRelativeDir = "IMAGES" + File.separator + "SMALL" + File.separator + year + File.separator + monthName + File.separator;
                        break;
                    }
                    newRelativeDir = "IMAGES" + File.separator + year + File.separator + monthName + File.separator;
                    break;
                }
                newRelativeDir = "FILES" + File.separator + ext + File.separator + year + File.separator + monthName + File.separator;
            }
        }
        this.incrementMapValue(this.fileDestinationDirectoryCountMap, newRelativeDir);
        if (this.verbose) {
            this.console.append("\tto copy in ." + File.separator + newRelativeDir);
            this.console.append("  |  " + sizeReport);
        }
        if (this.sort) {
            String targetDirPath = this.rootDirectory.getAbsolutePath() + File.separator + newRelativeDir;
            if (this.verbose) {
                this.console.append("      --> Moving : \n            '" + file.getAbsolutePath() + "'\n          to '" + targetDirPath + file.getName() + "'");
            }
            try {
                File targetDirectory = new File(targetDirPath);
                targetDirectory.mkdirs();
                Files.move(file.toPath(), Paths.get(this.rootDirectory.getAbsolutePath() + File.separator + newRelativeDir + file.getName(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                Log.error(ex.getCause() + " : " + ex.getMessage(), ex);
                this.console.append("ERROR : " + ex.getClass().getName() + " : " + ex.getMessage());
            }
        }
    }

    private void provideAnalyseResult(long durationMs) {
        if (durationMs > 3600000L) {
            this.console.append("\nExecute analyse in " + Math.round(durationMs / 3600000L) + "h " + Math.round(durationMs % 60000L * 60L / 60000L) + "min" + Math.round(durationMs % 60000L * 60L % 60000L / 1000L) + "s");
        } else if (durationMs > 60000L) {
            this.console.append("\nExecute analyse in " + Math.round(durationMs / 60000L) + "min " + Math.round(durationMs % 60000L / 1000L) + "s");
        } else if (durationMs > 1000L) {
            this.console.append("\nExecute analyse in " + (float)durationMs / 1000.0f + "s");
        } else {
            this.console.append("\nExecute analyse in " + durationMs + "ms");
        }
        this.console.append("\n" + this.getFileCount() + " files, " + this.getDirectoryCount() + " directories");
        this.console.append("\n" + (double)Math.round((double)this.getTotalSize() / 10000.0) / 100.0 + " Mb");
        this.console.setCaretPosition(this.console.getText().length());
        this.console.append("\n\n *** File Types ***");
        for (Map.Entry<String, Integer> cur : this.getFileTypeCountMap().entrySet()) {
            this.console.append("\n" + cur.getKey() + " : " + cur.getValue() + " files");
        }
        this.console.setCaretPosition(this.console.getText().length());
        this.console.append("\n\n *** File Months ***");
        for (Map.Entry<String, Integer> cur : this.getFileMonthCountMap().entrySet()) {
            this.console.append("\n" + cur.getKey() + " : " + cur.getValue() + " files");
        }
        this.console.setCaretPosition(this.console.getText().length());
        this.console.append("\n\n *** Destination Directory ***");
        for (Map.Entry<String, Integer> cur : this.getFileDestinationDirectoryCountMap().entrySet()) {
            this.console.append("\n" + cur.getKey() + " : " + cur.getValue() + " files");
        }
        this.console.setCaretPosition(this.console.getText().length());
    }

    private void incrementMapValue(Map<String, Integer> map, String key) {
        if (map.containsKey(key)) {
            map.put(key, map.get(key) + 1);
        } else {
            map.put(key, 1);
        }
    }

    public long getDirectoryCount() {
        return this.directoryCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public Map<String, Integer> getFileTypeCountMap() {
        return this.fileTypeCountMap;
    }

    public Map<String, Integer> getFileMonthCountMap() {
        return this.fileMonthCountMap;
    }

    public SortedMap<String, Integer> getFileDestinationDirectoryCountMap() {
        return this.fileDestinationDirectoryCountMap;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public boolean isResursiveTreatment() {
        return this.resursiveTreatment;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public boolean isSort() {
        return this.sort;
    }
}

