/*
 * Decompiled with CFR 0.152.
 */
package com.malchrosoft.filesorter.constant;

import java.util.HashMap;
import java.util.Map;

public enum TiffTag {
    NEW_SUBFILE_TYPE(254, "New Subfile Type"),
    IMAGE_WIDTH(256, "Image Width"),
    IMAGE_HEIGHT(257, "Image Height"),
    BITS_PER_SAMPLE(258, "Bits per sample"),
    COMPRESSION(259, "Compression"),
    PHOTOMETRIC_INTERPRETATION(262, "Photometric Interpretation"),
    THRESHHOLDING(263, "Threshholding"),
    CELL_WIDTH(264, "Cell Width"),
    CELL_LENGTH(265, "Cell Length"),
    FILL_ORDER(266, "Fill Order"),
    IMAGE_DESCRIPTION(270, "Image Description"),
    MAKE(271, "Make"),
    MODEL(272, "Model"),
    STRIP_OFFSETS(273, "Strip Offsets"),
    ORIENTATION(274, "Orientation"),
    SAMPLES_PER_PIXEL(277, "Samples Per Pixel"),
    ROWS_PER_STRIP(278, "Rows Per Strip"),
    STRIP_BYTE_COUNTS(279, "Strip Byte Counts"),
    MIN_SAMPLE_VALUE(280, "Min Sample Value"),
    MAX_SAMPLE_VALUE(281, "Max Sample Value"),
    X_RESOLUTION(282, "X Resolution"),
    Y_RESOLUTION(283, "Y Resolution"),
    PLANAR_CONFIGURATION(284, "Planar Configuration"),
    FREE_OFFSETS(288, "Free Offsets"),
    FREE_BYTE_COUNTS(289, "Free Byte Counts"),
    GRAY_RESPONSE_UNIT(290, "Gray Response Unit"),
    GRAY_RESPONSE_CURVE(291, "Gray Response Curve"),
    RESOLUTION_UNIT(296, "Resolution Unit"),
    SOFTWARE(305, "Software"),
    DATETIME(306, "Date Time"),
    ARTIST(315, "Artist"),
    HOST_COMPUTER(316, "Host Computer"),
    COLOR_MAP(320, "Color Map"),
    EXTRA_SAMPLES(338, "Extra Samples"),
    COPYRIGHT(33432, "Copyright");

    private int id;
    private String description;
    private static final Map<Integer, TiffTag> byIdMap;
    public static final String TIFF_TYPE_DESCRIPTION = "Tiff";

    private TiffTag(int id) {
        this(id, null);
    }

    private TiffTag(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.name().toLowerCase();
        }
        return this.description;
    }

    public int getId() {
        return this.id;
    }

    private static Map<Integer, TiffTag> initByIdMap() {
        HashMap<Integer, TiffTag> map = new HashMap<Integer, TiffTag>();
        for (TiffTag t : TiffTag.values()) {
            map.put(t.id, t);
        }
        return map;
    }

    public static final TiffTag get(int id) {
        return byIdMap.get(id);
    }

    static {
        byIdMap = TiffTag.initByIdMap();
    }
}

