/*
 * Copyright MalchroSoft - Aymeric MALCHROWICZ. All right reserved.
 * The source code that contains this comment is an intellectual property
 * of MalchroSoft [Aymeric MALCHROWICZ]. Use is subject to licence terms.
 */

/*
 * Game.java
 *
 * Created on 14 août 2010, 17:34:51
 */
package robotsfights;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Random;
import javax.swing.JLabel;
import robotsfights.robot.Robot;

/**
 *
 * @author Aymeric Malchrowicz
 */
public class Game extends javax.swing.JFrame
{
    private GamePanel gamePanel;
    private boolean inGame;

    /** Creates new form Game */
    public Game()
    {
        initComponents();
        this.gamePanel = new GamePanel();
        this.setPreferredSize(new Dimension(500, 500));
        this.setSize(new Dimension(500, 500));
        this.jPanel1.add(this.gamePanel, BorderLayout.CENTER);
        this.inGame = false;
        
        this.initGame();
    }

    private void initGame()
    {
        this.inGame = false;
        this.gamePanel.addRobot(new Robot(15, 20, Color.yellow, "Arthur"), 100, 100);
        this.gamePanel.addRobot(new Robot(20, 20, Color.orange, "X3PO"), 130, 180);
        this.gamePanel.addRobot(new Robot(10, 10, Color.cyan, "R2D2"), 230, 280);
        this.gamePanel.addRobot(new Robot(15, 10, Color.red, "Billy"), 200, 170);
        this.gamePanel.addRobot(new Robot(20, 15, Color.blue, "BLUA"), 130, 230);
        this.gamePanel.addRobot(new Robot(16, 10, Color.GREEN, "Grass47"), 230, 380);
        this.gamePanel.addRobot(new Robot(20, 18, Color.gray, "Fad2"), 420, 230);
        this.gamePanel.addRobot(new Robot(12, 10, Color.pink, "Porcinet"), 400, 380);

        Random ran = new Random();
        for (Robot r : this.gamePanel.getRobots())
        {
            r.setSpeedX((int) (ran.nextDouble() * 10) - 5);
            r.setSpeedY((int) (ran.nextDouble() * 10) - 5);
        }
    }

    public void startGame()
    {
        this.inGame = true;
        new Thread(new Runnable()
        {
            public void run()
            {
                inGame = true;
                while (gamePanel.getRobots().size() > 1 && inGame)
                {
                    try
                    {
                        Thread.sleep(20);
                    } catch (InterruptedException ex)
                    {
                    }
                    new Thread(new Runnable() {

                        public void run()
                        {
                            Game.this.gamePanel.repaint();
                        }
                    }).start();
                    getGameLabel().setText(gamePanel.getRobots().size() + " / " + gamePanel.getFights() + " combats");
                    getBestRobotLabel().setText(gamePanel.getBestRobot().getName());
                }
                inGame = false;
                getGameLabel().setText(gamePanel.getRobots().size() + " / " + gamePanel.getFights() + " combats     --> FINI !!");
            }
        }).start();
    }

    public JLabel getBestRobotLabel()
    {
        return bestRobotLabel;
    }

    public JLabel getGameLabel()
    {
        return gameLabel;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        statusPanel = new javax.swing.JPanel();
        gameLabel = new javax.swing.JLabel();
        bestRobotLabel = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenu1 = new javax.swing.JMenu();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMenuItem5 = new javax.swing.JMenuItem();
        jMenuItem3 = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JPopupMenu.Separator();
        jMenuItem4 = new javax.swing.JMenuItem();
        jMenu2 = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Robots Fights");
        setBackground(new java.awt.Color(0, 0, 0));
        setLocationByPlatform(true);
        setResizable(false);
        getContentPane().setLayout(new javax.swing.BoxLayout(getContentPane(), javax.swing.BoxLayout.LINE_AXIS));

        jPanel1.setBackground(new java.awt.Color(0, 0, 0));
        jPanel1.setForeground(new java.awt.Color(0, 255, 0));
        jPanel1.setLayout(new java.awt.BorderLayout());

        statusPanel.setMaximumSize(new java.awt.Dimension(32767, 25));
        statusPanel.setMinimumSize(new java.awt.Dimension(150, 25));
        statusPanel.setOpaque(false);
        statusPanel.setPreferredSize(new java.awt.Dimension(400, 25));
        statusPanel.setLayout(new java.awt.BorderLayout());

        gameLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        gameLabel.setForeground(new java.awt.Color(255, 255, 255));
        gameLabel.setText("X / X combats");
        gameLabel.setToolTipText("Compte rendu du jeu en cours");
        statusPanel.add(gameLabel, java.awt.BorderLayout.CENTER);

        bestRobotLabel.setForeground(new java.awt.Color(255, 255, 255));
        bestRobotLabel.setText("Best !");
        statusPanel.add(bestRobotLabel, java.awt.BorderLayout.LINE_END);

        jLabel3.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel3.setForeground(new java.awt.Color(255, 255, 255));
        jLabel3.setText("Robots : ");
        statusPanel.add(jLabel3, java.awt.BorderLayout.LINE_START);

        jPanel1.add(statusPanel, java.awt.BorderLayout.SOUTH);

        getContentPane().add(jPanel1);

        jMenu1.setText("Jeu");

        jMenuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_D, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem2.setText("Démarrer");
        jMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem2ActionPerformed(evt);
            }
        });
        jMenu1.add(jMenuItem2);

        jMenuItem5.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem5.setText("Arrêter");
        jMenuItem5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem5ActionPerformed(evt);
            }
        });
        jMenu1.add(jMenuItem5);

        jMenuItem3.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem3.setText("Apport en robots");
        jMenuItem3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem3ActionPerformed(evt);
            }
        });
        jMenu1.add(jMenuItem3);
        jMenu1.add(jSeparator1);

        jMenuItem4.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Q, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem4.setText("Quitter");
        jMenuItem4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem4ActionPerformed(evt);
            }
        });
        jMenu1.add(jMenuItem4);

        jMenuBar1.add(jMenu1);

        jMenu2.setText("?");

        jMenuItem1.setText("MalchroSoft");
        jMenu2.add(jMenuItem1);

        jMenuBar1.add(jMenu2);

        setJMenuBar(jMenuBar1);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jMenuItem2ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItem2ActionPerformed
    {//GEN-HEADEREND:event_jMenuItem2ActionPerformed
        startGame();
        this.jMenuItem2.setEnabled(false);
    }//GEN-LAST:event_jMenuItem2ActionPerformed

    private void jMenuItem3ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItem3ActionPerformed
    {//GEN-HEADEREND:event_jMenuItem3ActionPerformed
        this.initGame();
        this.jMenuItem2.setEnabled(true);
    }//GEN-LAST:event_jMenuItem3ActionPerformed

    private void jMenuItem4ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItem4ActionPerformed
    {//GEN-HEADEREND:event_jMenuItem4ActionPerformed
        this.dispose();
    }//GEN-LAST:event_jMenuItem4ActionPerformed

    private void jMenuItem5ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItem5ActionPerformed
    {//GEN-HEADEREND:event_jMenuItem5ActionPerformed
        this.inGame = false;
        this.jMenuItem2.setEnabled(true);
    }//GEN-LAST:event_jMenuItem5ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        java.awt.EventQueue.invokeLater(new Runnable()
        {
            public void run()
            {
                new Game().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel bestRobotLabel;
    private javax.swing.JLabel gameLabel;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenu jMenu2;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JMenuItem jMenuItem4;
    private javax.swing.JMenuItem jMenuItem5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPopupMenu.Separator jSeparator1;
    private javax.swing.JPanel statusPanel;
    // End of variables declaration//GEN-END:variables
}
