/*
 * Copyright MalchroSoft - Aymeric MALCHROWICZ. All right reserved.
 * The source code that contains this comment is an intellectual property
 * of MalchroSoft [Aymeric MALCHROWICZ]. Use is subject to licence terms.
 */

/*
 * GamePanel.java
 *
 * Created on 14 août 2010, 19:55:27
 */
package robotsfights;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import robotsfights.robot.Robot;

/**
 *
 * @author Aymeric Malchrowicz
 */
public class GamePanel extends javax.swing.JPanel
{
    private List<Robot> robots;
    private int fights;
    private Robot bestRobot;

    /** Creates new form GamePanel */
    public GamePanel()
    {
        initComponents();
        this.robots = new ArrayList<Robot>();
        this.fights = 0;
    }

    /**
     * Adds robots in the game panel
     * @param x
     * @param y
     */
    public void addRobot(Robot robot, int x, int y)
    {
        robot.setLocation(x, y);
        this.robots.add(robot);
    }

    public void removeRobot(Robot robot)
    {
        this.robots.remove(robot);
    }

    public List<Robot> getRobots()
    {
        return robots;
    }


    @Override
    public void paintComponent(Graphics g)
    {
        Graphics2D gGF = (Graphics2D) g;

        gGF.setColor(Color.black);
        Rectangle2D.Float background = new Rectangle2D.Float(
            0F, 0F, (float) this.getSize().width,
            (float) this.getSize().height);
        gGF.fill(background);
//        gGF.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
//            RenderingHints.VALUE_ANTIALIAS_ON);
        gGF.setBackground(Color.black);
        gGF.clearRect(0, 0, this.getWidth(), this.getHeight());
        for (Robot r : robots)
        {
            if (r.getLocation().getX() < 0 && r.getSpeedX() < 0) r.setSpeedX(-r.getSpeedX());
            if (r.getLocation().getY() < 0 && r.getSpeedY() < 0) r.setSpeedY(-r.getSpeedY());
            if (r.getLocation().getY() > (this.getHeight() - r.getBody().getHeight()) &&
                r.getSpeedY() > 0) r.setSpeedY(-r.getSpeedY());
            if (r.getLocation().getX() > (this.getWidth() - r.getBody().getWidth()) &&
                r.getSpeedX() > 0) r.setSpeedX(-r.getSpeedX());
            r.move();
            r.draw(gGF);
        }
        for (Robot r : robots)
        {
            if (r.collision(robots)) this.fights++;
        }
        for (int i = robots.size()-1; i >= 0; i--)
        {
            if (robots.get(i).getLife() <= 0) robots.remove(i);
        }
        this.bestRobot = this.robots.get(0);
        for (Robot r : robots)
        {
            if (r != this.bestRobot && r.getLife() > this.bestRobot.getLife()) this.bestRobot = r;
        }
    }

    public int getFights()
    {
        return fights;
    }

    public Robot getBestRobot()
    {
        return bestRobot;
    }



    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setBackground(new java.awt.Color(0, 0, 0));
        setDoubleBuffered(false);
        setMinimumSize(new java.awt.Dimension(400, 300));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
