/*
 * Decompiled with CFR 0.152.
 */
package robotsfights;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import robotsfights.robot.Robot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GamePanel
extends JPanel {
    private List<Robot> robots;
    private int fights;
    private Robot bestRobot;

    public GamePanel() {
        this.initComponents();
        this.robots = new ArrayList<Robot>();
        this.fights = 0;
    }

    public void addRobot(Robot robot, int x, int y) {
        robot.setLocation(x, y);
        this.robots.add(robot);
    }

    public void removeRobot(Robot robot) {
        this.robots.remove(robot);
    }

    public List<Robot> getRobots() {
        return this.robots;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D gGF = (Graphics2D)g;
        gGF.setColor(Color.black);
        Rectangle2D.Float background = new Rectangle2D.Float(0.0f, 0.0f, this.getSize().width, this.getSize().height);
        gGF.fill(background);
        gGF.setBackground(Color.black);
        gGF.clearRect(0, 0, this.getWidth(), this.getHeight());
        for (Robot r : this.robots) {
            if (r.getLocation().getX() < 0.0 && r.getSpeedX() < 0) {
                r.setSpeedX(-r.getSpeedX());
            }
            if (r.getLocation().getY() < 0.0 && r.getSpeedY() < 0) {
                r.setSpeedY(-r.getSpeedY());
            }
            if (r.getLocation().getY() > (double)this.getHeight() - r.getBody().getHeight() && r.getSpeedY() > 0) {
                r.setSpeedY(-r.getSpeedY());
            }
            if (r.getLocation().getX() > (double)this.getWidth() - r.getBody().getWidth() && r.getSpeedX() > 0) {
                r.setSpeedX(-r.getSpeedX());
            }
            r.move();
            r.draw(gGF);
        }
        for (Robot r : this.robots) {
            if (!r.collision(this.robots)) continue;
            ++this.fights;
        }
        for (int i = this.robots.size() - 1; i >= 0; --i) {
            if (this.robots.get(i).getLife() > 0) continue;
            this.robots.remove(i);
        }
        this.bestRobot = this.robots.get(0);
        for (Robot r : this.robots) {
            if (r == this.bestRobot || r.getLife() <= this.bestRobot.getLife()) continue;
            this.bestRobot = r;
        }
    }

    public int getFights() {
        return this.fights;
    }

    public Robot getBestRobot() {
        return this.bestRobot;
    }

    private void initComponents() {
        this.setBackground(new Color(0, 0, 0));
        this.setDoubleBuffered(false);
        this.setMinimumSize(new Dimension(400, 300));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

