/*
 * Decompiled with CFR 0.152.
 */
package robotsfights.robot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

public class Body
extends RoundRectangle2D.Float {
    public static int MAX_LENGTH = 20;
    public static int MIN_LENGTH = 5;
    private Color bgColor;
    private Color borderColor;
    private Point2D position;

    public Body(int width, int height, Color bgColor, Color borderColor) {
        this.width = width > MAX_LENGTH ? (float)MAX_LENGTH : (width < MIN_LENGTH ? (float)MIN_LENGTH : (float)width);
        this.height = height > MAX_LENGTH ? (float)MAX_LENGTH : (height < MIN_LENGTH ? (float)MIN_LENGTH : (float)height);
        this.bgColor = bgColor;
        this.borderColor = borderColor;
        this.position = new Point2D.Float(0.0f, 0.0f);
        this.setRoundRect(this.position.getX(), this.position.getY(), (double)this.width, (double)this.height, 4.0, 4.0);
    }

    public void setPosition(float x, float y) {
        this.position = new Point2D.Float(x, y);
        this.setRoundRect(this.position.getX(), this.position.getY(), (double)this.width, (double)this.height, 4.0, 4.0);
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void draw(Graphics2D g) {
        g.setColor(this.bgColor);
        g.fill(this);
    }
}

